/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import sedona.Component;
import sedona.Link;
import sedona.Slot;
import sedona.Type;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponentListener;
import sedona.sox.SoxException;
import sedona.util.ArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SoxComponent
extends Component {
    public static final int TREE = 1;
    public static final int CONFIG = 2;
    public static final int RUNTIME = 4;
    public static final int LINKS = 8;
    public SoxComponentListener listener;
    final SoxClient client;
    final int id;
    String name;
    int parent;
    int subscription;
    Link[] links;
    int[] children;
    int permissions;

    public SoxClient client() {
        return this.client;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Component getParent() {
        return this.parent();
    }

    public Component[] getChildren() {
        return this.children();
    }

    public Component getChild(String string) {
        return this.child(string);
    }

    public int parentId() {
        return this.parent;
    }

    public SoxComponent parent() {
        try {
            if (this.id == 0) {
                return null;
            }
            return this.client.load(this.parent);
        }
        catch (Exception exception) {
            throw new SoxException("Cannot read parent", exception);
        }
    }

    public int[] childrenIds() {
        return (int[])this.children.clone();
    }

    public SoxComponent[] children() {
        try {
            int[] nArray = this.children;
            SoxComponent[] soxComponentArray = this.client.load(nArray, false);
            boolean bl = false;
            int n = 0;
            while (n < soxComponentArray.length) {
                if (soxComponentArray[n] == null) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return soxComponentArray;
            }
            ArrayList<SoxComponent> arrayList = new ArrayList<SoxComponent>();
            int n2 = 0;
            while (n2 < soxComponentArray.length) {
                if (soxComponentArray[n2] != null) {
                    arrayList.add(soxComponentArray[n2]);
                }
                ++n2;
            }
            soxComponentArray = arrayList.toArray(new SoxComponent[arrayList.size()]);
            nArray = new int[soxComponentArray.length];
            n2 = 0;
            while (n2 < soxComponentArray.length) {
                nArray[n2] = soxComponentArray[n2].id;
                ++n2;
            }
            this.children = nArray;
            return soxComponentArray;
        }
        catch (Exception exception) {
            throw new SoxException("Cannot read children", exception);
        }
    }

    public SoxComponent child(String string) {
        SoxComponent[] soxComponentArray = this.children();
        int n = 0;
        while (n < soxComponentArray.length) {
            if (string.equals(soxComponentArray[n].name)) {
                return soxComponentArray[n];
            }
            ++n;
        }
        return null;
    }

    public Link[] links() {
        return (Link[])this.links.clone();
    }

    public int permissions() {
        return this.permissions;
    }

    synchronized void setChildren(int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            hashSet.add(new Integer(nArray[n]));
            ++n;
        }
        if (this.children != null) {
            n = 0;
            while (n < this.children.length) {
                SoxComponent soxComponent;
                if (!hashSet.contains(new Integer(this.children[n])) && (soxComponent = this.client.cache(this.children[n])) != null) {
                    this.client.cacheRemove(soxComponent);
                }
                ++n;
            }
        }
        this.children = nArray;
    }

    synchronized void addChild(int n) {
        int n2 = 0;
        while (n2 < this.children.length) {
            if (this.children[n2] == n) {
                return;
            }
            ++n2;
        }
        this.children = ArrayUtil.addOne(this.children, n);
    }

    synchronized void removeChild(int n) {
        this.children = ArrayUtil.removeOne(this.children, n);
    }

    public int subscription() {
        return this.subscription | this.client.allTreeEvents;
    }

    public void fireChanged(int n) {
        try {
            if (this.listener != null) {
                this.listener.changed(this, n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter printWriter) {
        Slot[] slotArray = this.type.slots;
        printWriter.println(this.type + ' ' + this.id + ' ' + this.name);
        int n = 0;
        while (n < slotArray.length) {
            Slot slot = slotArray[n];
            if (slot.isProp()) {
                printWriter.println("  " + slot.name + " = " + this.get(slot));
            }
            ++n;
        }
        printWriter.flush();
    }

    private final /* synthetic */ void this() {
        this.links = Link.none;
        this.children = new int[0];
    }

    public SoxComponent(SoxClient soxClient, int n, Type type) {
        super(type);
        this.this();
        this.client = soxClient;
        this.id = n;
    }
}

